<?php
/*--------------------------------------------------------------
   Dropdown.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option;

use Gambio\Admin\Modules\Language\Model\ValueObjects\LanguageCode;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItems;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItemTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown as Option;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item\Title;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item\Value;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Id;

class Dropdown
{
    /**
     * Return dropdown.
     */
    public function createDropdown(
        Id $id,
        string $value,
        DropdownItems $items,
        OptionTitles $titles
    ): Option {
        return Option::create($id,
                              $value,
                              $items,
                              $titles);
    }
    
    
    /**
     * Return dropdown items.
     */
    public function createItems(Item ...$items): DropdownItems
    {
        return DropdownItems::create(...$items);
    }
    
    
    /**
     * Return dropdown item.
     */
    public function createItem(Value $value, DropdownItemTitles $titles): Item
    {
        return Item::create($value, $titles);
    }
    
    
    /**
     * Return dropdown item titles.
     */
    public function createItemTitles(Title ...$titles): DropdownItemTitles
    {
        return DropdownItemTitles::create(...$titles);
    }
    
    
    /**
     * Return dropdown item title.
     */
    public function createItemTitle(LanguageCode $languageCode, string $title): Title
    {
        return Title::create($languageCode, $title);
    }
    
    
    /**
     * Return item value.
     */
    public function createValue(string $value): Value
    {
        return Value::create($value);
    }
}